import { useStore } from '../store/useStore'
import { 
  Layers, 
  Upload, 
  ArrowLeft, 
  Menu,
  Navigation
} from 'lucide-react'
import { motion } from 'framer-motion'

export function Header() {
  const { viewMode, setViewMode, selectedModel, selectModel, sidebarOpen, setSidebarOpen } = useStore()

  const handleBack = () => {
    selectModel(null)
    setViewMode('gallery')
  }

  return (
    <header className="glass sticky top-0 z-50 px-4 lg:px-6 py-3 shadow-soft">
      <div className="max-w-[1800px] mx-auto flex items-center justify-between">
        {/* Left section */}
        <div className="flex items-center gap-4">
          {viewMode === 'viewer' ? (
            <motion.button
              initial={{ opacity: 0, x: -10 }}
              animate={{ opacity: 1, x: 0 }}
              onClick={handleBack}
              className="flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-surface-100 transition-colors"
            >
              <ArrowLeft size={20} />
              <span className="hidden sm:inline font-medium">Back to Gallery</span>
            </motion.button>
          ) : (
            <div className="flex items-center gap-3">
              <div className="w-10 h-10 rounded-xl bg-gradient-to-br from-primary-400 to-primary-600 flex items-center justify-center shadow-glow">
                <Navigation className="text-white" size={22} />
              </div>
              <div>
                <h1 className="font-display font-bold text-xl gradient-text">Aerial Vision</h1>
                <p className="text-xs text-surface-500 hidden sm:block">3D Model Showcase</p>
              </div>
            </div>
          )}
        </div>

        {/* Center - Model name in viewer mode */}
        {viewMode === 'viewer' && selectedModel && (
          <motion.div 
            initial={{ opacity: 0, y: -10 }}
            animate={{ opacity: 1, y: 0 }}
            className="hidden md:flex flex-col items-center"
          >
            <h2 className="font-display font-semibold text-lg">{selectedModel.name}</h2>
            <p className="text-xs text-surface-500">
              {selectedModel.format.toUpperCase()} • {selectedModel.metadata?.fileSize || 'Unknown size'}
            </p>
          </motion.div>
        )}

        {/* Right section */}
        <div className="flex items-center gap-2">
          {viewMode === 'gallery' && (
            <>
              <button className="hidden sm:flex items-center gap-2 px-4 py-2 rounded-lg bg-primary-500 hover:bg-primary-600 text-white font-medium transition-colors shadow-soft">
                <Upload size={18} />
                <span>Upload Model</span>
              </button>
              <button className="sm:hidden p-2 rounded-lg bg-primary-500 hover:bg-primary-600 text-white transition-colors">
                <Upload size={20} />
              </button>
            </>
          )}
          
          {viewMode === 'viewer' && (
            <button
              onClick={() => setSidebarOpen(!sidebarOpen)}
              className="p-2 rounded-lg hover:bg-surface-100 transition-colors lg:hidden"
            >
              <Menu size={20} />
            </button>
          )}
          
          <button className="p-2 rounded-lg hover:bg-surface-100 transition-colors" title="View all models">
            <Layers size={20} />
          </button>
        </div>
      </div>
    </header>
  )
}

